--  ANMERKUNG: siehe "Y twawi.Views.Auftrag.sql"
CREATE OR REPLACE FUNCTION TSystem.views__wawi_einkauf__recreate() RETURNS void AS $$
  BEGIN
    DROP FUNCTION IF EXISTS twawi.beleg_p__einkauf__create__from__plain_art( varchar, varchar, varchar, integer, varchar, varchar, varchar, numeric, integer, numeric ); --RETURNS twawi.Ldsdok_Pos
    DROP FUNCTION IF EXISTS twawi.beleg_p__einkauf__from__txt__assign_art( twawi.ldsdok_pos );
    DROP FUNCTION IF EXISTS twawi.beleg_p__einkauf__from__txt__assign( twawi.ldsdok_pos, BestVorschlagPos );
    --
    -- Bestehende-Views droppen
        DROP VIEW IF EXISTS twawi.ldsdok_posext CASCADE;
        DROP VIEW IF EXISTS twawi.ldsdok_pos;
    --

    -- Basis-View => Updatable, da kann man reinschreiben. Nur Felder aus Basistabelle, keine NULLs, keine Funktionen, keine Felder anderer Tabellen.
    CREATE OR REPLACE VIEW twawi.ldsdok_pos AS
      SELECT
      -- Identifikatoren
        dbrid              AS dbrid                   ,--
        ld_id              AS p_id                    ,-- ID der Pos.
        ld_dokunr          AS p_dokunr                ,-- Referenz auf das zug. Dokument
        ld_code            AS p_code                  ,-- Code / Klassifikation / Belegtyp
        ld_auftg           AS p_nummer                ,-- Belegnummer
        ld_pos             AS p_pos                   ,-- Positionsnummer
        --                 AS p_parent                ,-- Übergeordnete Position (Strukt. Belege)
        --                 AS p_table                 ,-- Tabelle aus der die Position stammt
      -- Artikeldaten
        ld_aknr            AS p_aknr                  ,-- Artikelnummer
        ld_aknr_idx        AS p_aknr_idx              ,-- Artikelindex
        ld_akbz            AS p_akbez                 ,-- Überschriebene Artikelbezeichnung (wenn <> art.ak_bez)
        ld_bem             AS p_aknr_referenz         ,-- Referenzierte Artikelnummer (z.Bsp. Von Kunde oder Lieferant)
        ld_stk             AS p_menge                 ,-- Menge in Positions-ME
        ld_mce             AS p_me                    ,-- artmgc.m_id der Positions-ME
        ld_eklos           AS p_los                   ,-- Losgröße für Artikel
        ld_stk_uf1         AS p_menge_gme             ,-- Menge in GME
        --                 AS p_mengeb_gme            ,-- Menge bestellt in GME
        ld_stkl            AS p_mengel_gme            ,-- Menge geliefert in GME
        ld_stkf            AS p_mengef_gme            ,-- Menge fakturiert in GME
        --                 AS p_mengeo                ,-- Offene Menge
        --                 AS p_mengeo_gme            ,-- Offene Menge in GME
        ld_nident          AS p_norm                  ,-- Artikelnorm
        ld_ks              AS p_ks                    ,-- Zugeordnete Kostenstelle
        --                 AS p_gme                   ,-- artmgc.m_id der Grundmengeneinheit
        --                 AS p_mec                   ,-- ME-Code der Positions-ME
        --                 AS p_gmec                  ,-- ME-Code der Grund-ME
        --                 AS p_meuf                  ,-- Umrechnungsfaktor von Pos.ME zu GME
      -- Preisdaten
        ld_preis           AS p_preis                 ,-- Preis pro ME (enthält Preiseinheit)
        ld_preiseinheit    AS p_preiseinheit          ,-- Menge auf die sich p_preis bezieht
        ld_ep              AS p_preis_me              ,-- Preis pro ME
        ld_ekp_mce         AS p_pme                   ,-- artmgc.m_id Mengeneinheit - Preis

        ld_ep_basis_w      AS p_preis_gwaer           ,-- Preis pro ME in Grundwährung
        ld_ep_uf1          AS p_preis_gme             ,-- Preis pro GME
        ld_ep_uf1_basis_w  AS p_preis_gme_gwaer       ,-- Preis pro GME in Grundwährung
        ld_waer            AS p_waer                  ,-- Pos. Währungseinheit
        ld_kurs            AS p_kurs                  ,-- Pos. Kurs zur Basiswährung
        ld_steucode        AS p_scode                 ,-- Steuercode
        ld_steuproz        AS p_sproz                 ,-- Steuerprozentsatz
        ld_arab            AS p_rabatt                ,-- Rabattsatz (0...100)
        --                 AS p_CanRabatt             ,-- Kennzeichen Rabattfähig
      -- Adressdaten
        ld_kn              AS p_adkrz                 ,-- Adresskürzel (Kunde o. Lieferant)
        ld_krzl            AS p_adkrzl                ,-- Adresskürzel Lieferadresse
        ld_krzf            AS p_adkrzf                ,-- Adresskürzel Rechnungsadresse
        ld_lkontaktkrzl    AS p_apext                 ,-- Kürzel Ansprechpartner extern
        ld_lkontakt        AS p_apextname             ,-- Voller Name Ansprechpartner extern
        ld_kontakt         AS p_apint                 ,-- Kürzel Ansprechpartner intern
        --                 AS p_apintname             ,-- Voller Name Ansprechpartner intern
      -- Termine und Status
        insert_date        AS p_datum_eingang         ,-- Eingangsdatum
        ld_datum           AS p_datum_erfasst         ,-- Erfassdatum
        ld_term            AS p_datum_soll            ,-- Wunschdatum
        ld_terml           AS p_datum_ist             ,-- Bestätigtes Datum
        --                 AS p_datum_istsoll         ,-- COALESCE(Bestätigtes, Wunschdatum )
        --                 AS p_datum_storniert       ,-- Datum an dem die Pos. Storniert wurde
        --                 AS p_definitiv             ,-- Kennzeichen Pos. Definitiv
        ld_done            AS p_done                  ,-- Kennzeichen Pos. Erledigt
        ld_storno          AS p_storniert             ,-- Kennzeichen Pos. Storniert
        --                 AS p_IsBedarf              ,-- Kennzeichen bedarfswirksam
        --                 AS p_IsFertigung           ,-- Kennzeichen Fertigungsartikel
        --                 AS p_IsUmsatz              ,-- Kennzeichen umsatzwirksame Position
        ld_bstat           AS p_status                ,-- Allg. Status1
        ld_bstat1          AS p_status1               ,-- Allg. Status2
        ld_bstat2          AS p_status2               ,-- Allg. Status3
      -- Referenzen / Struktur
        --                 AS p_rahmen_id             ,-- p_ID des Rahmens oder Rahmenvertragsnummer
        --                 AS p_vorgaenger_table      ,--
        --                 AS p_vorgaenger_id         ,--
        ld_folgeap_op_ix   AS p_folgeap_op_ix         ,
        ld_rhl_nr          AS p_rahmen_ident_concat   ,
        ld_ekref           AS p_refnummer             ,-- Referenz auf ext.Nummer (Z.Bsp. Bestell-Nr. Kunde)
        --                 AS p_refpos                ,-- Referenz auf ext.Position (Z.Bsp. Bestellpos. - Kunde)
        ld_an_nr           AS p_an_nr                 ,-- Projektnummer
        ld_vtp_id          AS p_vtp_id                ,-- ID der zugehörigen Vertragsposition
        ld_abk             AS p_ab_ix                 ,-- Zugehörige ABK
        ld_q_nr            AS p_q_nr                  ,-- QAB-Bezug
      -- Erweiterte Positionsdaten
        ld_konto           AS p_Konto                 ,--
        ld_txt             AS p_txt_ext               ,--
        ld_txt_rtf         AS p_txt_ext_rtf           ,--
        ld_txtint          AS p_txt_int               ,--
        ld_txtint_rtf      AS p_txt_int_rtf           ,--
        ld_lagzu_txt       AS p_txt_lagzu             ,
        ld_lagzu_txt_rtf   AS p_txt_lagzu_rtf
      FROM ldsdok;
    --

    -- Erweiterter Anzeige-View => Nur lesbar. Felder aus Basis-View und angejointen Tabellen.
    CREATE OR REPLACE VIEW twawi.ldsdok_posext AS
      SELECT
      -- Identifikatoren
        pos.dbrid          AS dbrid                      ,--
        p_id                                             ,-- ID der Pos.
        p_dokunr::VARCHAR  AS p_dokunr                   ,-- Referenz auf das zug. Dokument
        p_code                                           ,-- Code / Klassifikation / Belegtyp
        p_nummer                                         ,-- Belegnummer
        p_pos                                            ,-- Positionsnummer
        NULL::INTEGER      AS p_parent                   ,-- Übergeordnete Position (Strukt. Belege)
        'ldsdok'::VARCHAR  AS p_table                    ,-- Tabelle aus der die Position stammt
      -- Artikeldaten
        p_aknr                                           ,-- Artikelnummer
        COALESCE(p_aknr_idx, ak_idx) AS p_aknr_idx       ,-- Artikelindex
        COALESCE(p_akbez, ak_bez) AS p_akbez             ,-- Überschriebene Artikelbezeichnung (wenn <> art.ak_bez)
        p_aknr_referenz                                  ,-- Referenzierte Artikelnummer (z.Bsp. Von Kunde oder Lieferant)
        p_menge                                          ,-- Menge in Positions-ME
        p_me                                             ,-- artmgc.m_id der Positions-ME
        p_los                                            ,-- Losgröße für Artikel
        p_menge_gme                                      ,-- Menge in GME
        NULL::NUMERIC      AS p_mengeb_gme               ,-- Menge bestellt in GME
        p_mengel_gme                                     ,-- Menge geliefert in GME
        p_mengef_gme                                     ,-- Menge fakturiert in GME
        tartikel.me__menge_uf1__in__menge(p_me, GREATEST(p_menge_gme-p_mengel_gme, 0)) AS p_mengeo,-- Noch zu bestellende Menge
        GREATEST(p_menge_gme-p_mengel_gme, 0)                     AS p_mengeo_gme,-- Noch zu bestellende Menge in GME
        p_norm                                           ,-- Artikelnorm
        p_ks                                             ,-- Zugeordnete Kostenstelle
      -- Mengeneinheitsdaten
        MEData.p_gme                                     ,-- Artmgc.m_id der Grundmengeneinheit
        MEData.p_mec                                     ,-- ME-Code der Positions-ME
        MEData.p_gmec                                    ,-- ME-Code der Grund-ME
        MEData.p_meuf                                    ,-- Umrechnungsfaktor Positions-ME zu Grund-ME
        MEData.p_meiso                                   ,-- ISO-Code der Positions-ME
        MEData.p_gmeiso                                  ,-- ISO-Code der Grund-ME
      -- Preisdaten
        p_preis                                          ,-- Preis pro ME (enthält Preiseinheit)
        p_preiseinheit                                   ,-- Menge auf die sich p_preis bezieht
        p_preis_me                                       ,-- Preis pro ME (Einzelpreis)
        p_preis_gwaer                                    ,-- Preis pro ME in Grundwährung
        p_preis_gme                                      ,-- Preis pro GME
        p_preis_gme_gwaer                                ,-- Preis pro GME in Grundwährung
        p_waer                                           ,-- Pos. Währungseinheit
        p_kurs                                           ,-- Pos. Kurs zur Basiswährung
        p_scode                                          ,-- Steuercode
        p_sproz                                          ,-- Steuerprozentsatz
        p_rabatt                                         ,-- Rabattsatz (0...100)
        NULL::BOOLEAN      AS p_canRabatt                ,-- Kennzeichen Rabattfähig
        steu_txt           AS p_sbez                     ,-- Steuerbezeichnung
      -- Positionswerte
        ld_netto           AS p_wert_netto               ,-- Positionswert inkl. AbZuschläge, exkl. Steuern
        ld_brutto          AS p_wert_brutto              ,-- Positionswert inkl. AbZuschläge, inkl. Steuern
        ld_netto_basis_w   AS p_wert_netto_gwaer         ,-- Positionswert inkl. AbZuschläge, exkl. Steuern, in Grundwährung
        ld_brutto_basis_w  AS p_wert_brutto_gwaer        ,-- Positionswert inkl. AbZuschläge, inkl. Steuern, in Grundwährung
      -- Adressdaten
        p_adkrz                                          ,-- Adresskürzel (Kunde o. Lieferant)
        p_adkrzl                                         ,-- Adresskürzel Lieferadresse
        p_adkrzf                                         ,-- Adresskürzel Rechnungsadresse
        p_apext                                          ,-- Kürzel Ansprechpartner extern
        p_apExtName                                      ,-- Voller Name Ansprechpartner extern
        p_apInt                                          ,-- Kürzel Ansprechpartner intern
        nameAufloesen(p_apInt) AS p_apintname            ,-- Voller Name Ansprechpartner intern
      -- Termine und Status
        p_datum_eingang                                  ,-- Eingangsdatum
        p_datum_erfasst                                  ,-- Erfassdatum
        COALESCE(p_datum_soll, termweek_to_date(ld_termweek, true)) AS p_datum_soll,-- Wunschdatum
        COALESCE(p_datum_ist, termweek_to_date(ld_termweekl, true)) AS p_datum_ist,-- Bestätigtes Datum
        COALESCE(p_datum_ist, termweek_to_date(ld_termweekl, true), p_datum_soll, termweek_to_date(ld_termweek, true))
                           AS p_datum_istsoll            ,-- Eigentlicher Termin
        NULL::DATE         AS p_datum_storniert          ,-- Datum an dem die Pos. Storniert wurde
        true               AS p_definitiv                ,-- Kennzeichen Pos. Definitiv
        p_done                                           ,-- Kennzeichen Pos. Erledigt
        p_storniert                                      ,-- Kennzeichen Pos. Storniert
        NOT ld_nbedarf     AS p_IsBedarf                 ,-- Kennzeichen bedarfswirksame Position
        ak_fertigung       AS p_IsFertigung              ,-- Kennzeichen Fertigungsartikel (oder Fert.Position)
        NOT twawi.ldsdok__ld_pos0defini()  AS p_IsUmsatz                 ,-- Kennzeichen umsatzwirksame Position
        p_status                                         ,-- Allg. Status1
        p_status1                                        ,-- Allg. Status2
        p_status2                                        ,-- Allg. Status3
      -- Referenzen / Struktur
        (SELECT ld_id FROM ldsdok WHERE (ld_code = 'R' OR ld_pos = 0) AND ld_auftg||'/'||ld_pos = ld_rhl_nr)
                           AS p_rahmen_id                ,-- p_ID des Rahmens oder Rahmenvertragsnummer
        NULL::VARCHAR      AS p_vorgaenger_table         ,--
        NULL::INTEGER      AS p_vorgaenger_id            ,--
        p_refnummer                                      ,-- Referenz auf ext.Nummer   (Z.Bsp. Bestell-Nr.  Kunde)
        NULL::INTEGER      AS p_refpos                   ,-- Referenz auf ext.Position (Z.Bsp. Bestell-Pos. Kunde)
        p_an_nr                                          ,-- Projektnummer
        p_vtp_id                                         ,-- ID der zugehörigen Vertragsposition
        p_ab_ix                                          ,-- Zugehörige ABK
        p_q_nr                                           ,-- QAB-Bezug
      -- Erweiterte Positionsdaten
        p_konto                                          ,-- Kontierung
        p_txt_ext                                        ,-- Positionstext extern
        p_txt_ext_rtf                                    ,--
        p_txt_int                                        ,-- Positionstext intern
        p_txt_int_rtf                                     --
      FROM twawi.Ldsdok_pos AS pos
        JOIN ldsdok            ON ld_id   = p_id
        JOIN art               ON ak_nr   = p_aknr
        LEFT JOIN steutxt      ON steu_z  = p_scode
        -- Informationen zur Mengenumrechnung mit aufnehmen
        , LATERAL( SELECT m2.m_id     AS p_gme,
                          m1.m_mgcode AS p_mec,
                          m2.m_mgcode AS p_gmec,
                          m1.m_uf     AS p_meuf,
                          lang_artmgc_id_iso(p_me)    AS p_meiso,
                          lang_artmgc_id_iso(m2.m_id) AS p_gmeiso
                   FROM art JOIN artmgc m1  ON (m1.m_ak_nr  = ak_nr) AND (m1.m_id = p_me)
                            JOIN artmgc m2  ON (m2.m_ak_nr  = ak_nr) AND (m2.m_mgcode = ak_standard_mgc)
                   WHERE m1.m_ak_nr = pos.p_aknr ) AS medata
      ;
    --

    --
    EXECUTE $f$

        -- Texte-Funktionen
        CREATE OR REPLACE FUNCTION twawi.beleg_p__einkauf__from__txt__assign_art(
              rec_einkauf twawi.ldsdok_pos
          ) RETURNS twawi.ldsdok_pos AS $wrapper$
          BEGIN
              RETURN
                jsonb_populate_record( null::twawi.ldsdok_pos, jb )
                FROM twawi.beleg_p__einkauf__from__txt__assign_art__jsonb( to_jsonb(rec_einkauf) ) AS jb;

          END $wrapper$ LANGUAGE plpgsql;

        CREATE OR REPLACE FUNCTION twawi.beleg_p__einkauf__from__txt__assign(
              rec_einkauf twawi.ldsdok_pos,
              source_bv BestVorschlagPos
          ) RETURNS twawi.ldsdok_pos AS $wrapper$
          BEGIN
              RETURN
                jsonb_populate_record( null::twawi.ldsdok_pos, jb )
                FROM twawi.beleg_p__einkauf__from__txt__assign_bestvorschlag__jsonb(
                        to_jsonb(rec_einkauf),
                        to_jsonb(source_bv)
                     ) AS jb
              ;

          END $wrapper$ LANGUAGE plpgsql;

        -- Einkauf - Funktionen (Wrapper für richtige Typ twawi.ldsdok_pos (intern nur jsonb)
        CREATE OR REPLACE FUNCTION twawi.beleg_p__einkauf__create__from__plain_art(
             _flags_enum varchar,
             _code varchar,
             _nummer varchar,
             _pos integer,
             _adkrz_lieferant varchar,
             _aknr varchar,
             _akbez varchar,
             _menge numeric,
             _me integer = null,
             _los numeric = null,
             _adkrz_lieferadresse varchar = '#'
          ) RETURNS twawi.ldsdok_pos AS $wrapper$
          BEGIN

            RETURN
              jsonb_populate_record( null::twawi.ldsdok_pos, jb )
              FROM twawi.beleg_p__einkauf__create__from__plain_art__jsonb(
                      _flags_enum,
                      _code,
                      _nummer,
                      _pos,
                      _adkrz_lieferant,
                      _aknr,
                      _akbez,
                      _menge,
                      _me,
                      _los,
                      _adkrz_lieferadresse
              ) jb
            ;

          END $wrapper$ LANGUAGE plpgsql;

    $f$ -- EXECUTE end

    RETURN;

  END $$ LANGUAGE plpgsql;
--


CREATE OR REPLACE FUNCTION tsystem.views__wawi_einkauf_anfpos__recreate() RETURNS VOID AS $$
  BEGIN
    -- Bestehende-Views droppen
        DROP VIEW IF EXISTS twawi.einkauf_anfpos;
    --

    -- Basis-View => Updatable, da kann man reinschreiben. Nur Felder aus Basistabelle, keine NULLs, keine Funktionen, keine Felder anderer Tabellen.
    CREATE OR REPLACE VIEW twawi.einkauf_anfpos AS
      -- Felder sind zu klären und zu ergänzen: https://redmine.prodat-sql.de/issues/13399
      SELECT
      -- Identifikatoren
        dbrid              AS dbrid                   ,--
        aart_id            AS p_id                    ,-- ID der Pos.
        --                 AS p_dokunr                ,-- Referenz auf das zug. Dokument
        --                 AS p_code                  ,-- Code / Klassifikation / Belegtyp
        aArt_anf_nr        AS p_k_nummer              ,-- Belegnummer
        aArt_pos           AS p_pos                   ,-- Positionsnummer
        --                 AS p_parent                ,-- Übergeordnete Position (Strukt. Belege)
        --                 AS p_table                 ,-- Tabelle aus der die Position stammt
      -- Artikeldaten
        aArt_ak_nr         AS p_aknr                  ,-- Artikelnummer
        aArt_aknr_idx      AS p_aknr_idx              ,-- Artikelindex
        aArt_bez           AS p_akbez                 ,-- Überschriebene Artikelbezeichnung (wenn <> art.ak_bez)
        aArt_ref           AS p_aknr_referenz         ,-- Referenzierte Artikelnummer (z.Bsp. Von Kunde oder Lieferant)
        aArt_menge         AS p_menge                 ,-- Menge in Positions-ME
        aArt_m_id          AS p_me_mgcode             ,-- artmgc.m_id der Positions-ME
       ---     ld_eklos           AS p_los                   ,-- Losgröße für Artikel
      -- Termine und Status
        insert_date        AS p_datum_erfasst         ,-- Erfassdatum
        aArt_termin        AS p_datum_soll            ,-- Wunschdatum
        aArt_done          AS p_done                  ,-- Kennzeichen Pos. Erledigt
        aArt_storno        AS p_storno                ,-- Kennzeichen Pos. Storniert
        aart_anfrage       AS p_nurAnfrage            ,-- Anfrage nur zur
        --                 AS p_IsBedarf              ,-- Kennzeichen bedarfswirksam
        --                 AS p_IsFertigung           ,-- Kennzeichen Fertigungsartikel
        --                 AS p_IsUmsatz              ,-- Kennzeichen umsatzwirksame Position
      -- Referenzen / Struktur
      -- Erweiterte Positionsdaten
        aArt_ks            AS p_ks                    ,-- Zugeordnete Kostenstelle
        aArt_konto         AS p_Konto                 ,--
        aArt_txt           AS p_txt_ext               ,--
        aArt_txt_rtf       AS p_txt_ext_rtf           ,--
        aArt_txtint        AS p_txt_int               ,--
        aArt_txtint_rtf    AS p_txt_int_rtf           ,--
        --specific
        aArt_bemerk        AS p_txt_bemerk            ,
        aArt_ldid          AS p_einkauf_p_id          ,

        -- Unklare / zu klärende Felder: https://redmine.prodat-sql.de/issues/13399
        -- wahrscheinlich wie sie sind einkommentieren, ersten Anwendungsfall abwarten für finale Entscheidung
         -- aArt_termweek        VARCHAR(7),                                     -- Terminwoche
        aArt_op_ix         AS p_op_ix                 , --  opl,
        aArt_ab_ix         AS p_ab_ix                 , --  abk
        aart_o2_id         AS p_o2_id                 , --  op2
        aart_a2_id         AS p_a2_id                 , --  ab2
        aArt_o2_n          AS p_o2_n                    --  Arbeitsgangnummer (aus ASK), interpretiert als Arbeitsgangnummer aus ABK, wenn ABK-Index angegeben ist

      FROM anfart;
    --
    RETURN;
  END $$ LANGUAGE plpgsql;

-- SELECT TSystem.views__Wawi_Einkauf__recreate();
-- SELECT TSystem.views__Wawi_Einkauf_anfpos__recreate();
